# 이진 탐색 (분할 정복 알고리즘)

## 문제

원소 $n$개로 이루어진 정렬된 배열이 주어졌을 때, 입력받은 원소의 인덱스를 반환하는 함수를 작성하라.

## 접근 방식

- 배열을 반으로 계속 나누어 가며 탐색할 것이다(분할 정복).
- 먼저, 주어진 배열에서 가운데에 있는 원소를 선택한다.
- 만약 선택한 원소와 찾는 원소가 같다면, 그 인덱스를 반환하고 종료한다.
- 만약 선택한 원소가 찾는 원소보다 작다면, 배열의 오른쪽 절반만 고려하면 된다. 오른쪽 절반 배열에 대해 처음부터 반복한다.
- 만약 선택한 원소가 찾는 원소보다 크다면, 배열의 왼쪽 절반만 고려하면 된다. 왼쪽 절반 배열에 대해 처음부터 반복한다.
- 만약 찾는 원소가 초기 배열에 없다면, -1을 반환하면 된다.(분할 정복을 반복하다 보면 배열의 크기가 1이하가 되고, 이때 찾는 원소가 없다면 없는 것이다.) 
  
## 시간 복잡도

최악의 경우: $O(\log n)$
최선의 경우: $O(1)$
(찾는 원소가 초기 배열의 가운데에 있는 경우)

## 공간 복잡도

단순 반복으로 구현한 경우, $O(1)$
재귀를 사용하는 경우, $O(\log n)$
(재귀함수를 부를 때마다 스택에 쌓이므로)

## 예시

```
arr = [1, 2, 3, 4, 5, 6, 7]
target = 2

중간 원소는 4로, 목표인 2보다 크다. 그러므로 배열의 왼쪽 절반을 탐색한다.

arr = [1, 2, 3]

중간 원소가 목표와 같으므로 이 원소의 인덱스를 반환한다.
```

```
arr = [1, 2, 3, 4, 5, 6, 7]
target = 9

중간 원소는 4로, 목표인 9보다 작다. 그러므로 배열의 오른쪽 절반을 탐색한다.

arr = [5, 6, 7]

중간 원소는 6으로, 목표보다 작다. 그러므로 오른쪽 절반을 탐색한다.

arr = [7]

유일한 원소가 목표와 같지 않으므로 9가 배열에 들어있지 않다고 판단하여 -1을 반환한다.
```

## 구현

- [자바](https://github.com/TheAlgorithms/Java/blob/master/src/main/java/com/thealgorithms/searches/BinarySearch.java)
- [C++](https://github.com/TheAlgorithms/C-Plus-Plus/blob/master/Search/Binary%20Search.cpp)
- [파이썬](https://github.com/TheAlgorithms/Python/blob/master/searches/binary_search.py)
- [C#](https://github.com/TheAlgorithms/C-Sharp/blob/master/Algorithms/Search/BinarySearcher.cs)
- [C](https://github.com/TheAlgorithms/C/blob/master/searching/Binary_Search.c)

## 영상 URL

- [CS50: 이진 탐색](https://www.youtube.com/watch?v=5xlIPT1FRcA)

## 시각화된 설명

- [Tute 보드](https://boardhub.github.io/tute/?wd=binarySearchAlgo2)
